import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Define colors for clear and not clear statuses
clear_color = 'green'
not_clear_color = 'red'

# Create a figure and axis
fig, ax = plt.subplots(figsize=(12, 4))

# Function to draw a curb with cars
def draw_curb(ax, curb_id, x_position, cars):
    # Draw the curb rectangle
    curb_rect = patches.Rectangle((x_position, 0.5), 1, 1, linewidth=1, edgecolor='black', facecolor=not_clear_color if cars else clear_color)
    ax.add_patch(curb_rect)
    ax.text(x_position + 0.5, 1.7, f'curb_{curb_id}', ha='center', va='center', fontsize=8, color='white' if cars else 'black')
    
    # Draw cars
    for i, (car_id, status) in enumerate(cars):
        car_color = clear_color if status == 'clear' else not_clear_color
        car_circle = patches.Circle((x_position + 0.5, 1.2 - i * 0.4), 0.15, linewidth=1, edgecolor='black', facecolor=car_color)
        ax.add_patch(car_circle)
        ax.text(x_position + 0.5, 1.2 - i * 0.4, f'car{car_id}\n{status}', ha='center', va='center', fontsize=6, color='white' if status == 'not clear' else 'black')

# Draw curbs and cars
draw_curb(ax, 0, 0, [(6, 'blocked'), (7, 'clear')])
draw_curb(ax, 1, 1.5, [(1, 'blocked'), (8, 'clear')])
draw_curb(ax, 2, 3, [(9, 'blocked'), (4, 'clear')])
draw_curb(ax, 3, 4.5, [(3, 'clear')])
draw_curb(ax, 4, 6, [(0, 'clear')])
draw_curb(ax, 5, 7.5, [(5, 'clear')])
draw_curb(ax, 6, 9, [(2, 'clear')])

# Set limits and hide axes
ax.set_xlim(-0.5, 10.5)
ax.set_ylim(0, 2)
ax.axis('off')

# Create legend
legend_patches = [
    patches.Patch(color=clear_color, label='Clear'),
    patches.Patch(color=not_clear_color, label='Blocked')
]
ax.legend(handles=legend_patches, loc='upper right', fontsize=8)

# Save the figure
plt.savefig('parking/one_shot/ini_diagram_code/attempts/attempt_29.png', bbox_inches='tight')
plt.close(fig)
# VERIFICATION FAILED:
# The diagram incorrectly shows all curbs as blocked (red), while some should be clear (green) according to the initial state.
